
// CPP2010-USBisoVMexampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CPP2010-USBisoVMexample.h"
#include "CPP2010-USBisoVMexampleDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CCPP2010USBisoVMexampleDlg dialog




CCPP2010USBisoVMexampleDlg::CCPP2010USBisoVMexampleDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CCPP2010USBisoVMexampleDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCPP2010USBisoVMexampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, textBox1);
	DDX_Control(pDX, IDC_BUTTON1, button1);
	DDX_Control(pDX, IDC_BUTTON2, button2);
	DDX_Control(pDX, IDC_BUTTON3, button3);
	DDX_Control(pDX, IDC_BUTTON4, button4);
	DDX_Control(pDX, IDC_BUTTON5, button5);
	DDX_Control(pDX, IDC_BUTTON6, button6);
	DDX_Control(pDX, IDC_BUTTON7, button7);
	DDX_Control(pDX, IDC_BUTTON8, button8);
	DDX_Control(pDX, IDC_BUTTON9, button9);
	DDX_Control(pDX, IDC_BUTTON10, button10);
	DDX_Control(pDX, IDC_BUTTON11, button11);
}

BEGIN_MESSAGE_MAP(CCPP2010USBisoVMexampleDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &CCPP2010USBisoVMexampleDlg::button1_Click)
	ON_BN_CLICKED(IDC_BUTTON2, &CCPP2010USBisoVMexampleDlg::button2_Click)
	ON_BN_CLICKED(IDC_BUTTON3, &CCPP2010USBisoVMexampleDlg::button3_Click)
	ON_BN_CLICKED(IDC_BUTTON4, &CCPP2010USBisoVMexampleDlg::button4_Click)
	ON_BN_CLICKED(IDC_BUTTON5, &CCPP2010USBisoVMexampleDlg::button5_Click)
	ON_BN_CLICKED(IDC_BUTTON6, &CCPP2010USBisoVMexampleDlg::button6_Click)
	ON_BN_CLICKED(IDC_BUTTON7, &CCPP2010USBisoVMexampleDlg::button7_Click)
	ON_BN_CLICKED(IDC_BUTTON8, &CCPP2010USBisoVMexampleDlg::button8_Click)
	ON_BN_CLICKED(IDC_BUTTON9, &CCPP2010USBisoVMexampleDlg::button9_Click)
	ON_BN_CLICKED(IDC_BUTTON10, &CCPP2010USBisoVMexampleDlg::button10_Click)
	ON_BN_CLICKED(IDC_BUTTON11, &CCPP2010USBisoVMexampleDlg::button11_Click)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


// CCPP2010USBisoVMexampleDlg message handlers

BOOL CCPP2010USBisoVMexampleDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	LoadDll();
	isoVMfound = "";

	HICON hIcon = LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON1));
	SetIcon(hIcon, FALSE);

	textBox1.Clear();
	textBox1.SetSel(-1, -1);
	textBox1.ReplaceSel("(C)opyright 2010 EtherTek Circuits\r\n");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCPP2010USBisoVMexampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCPP2010USBisoVMexampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CCPP2010USBisoVMexampleDlg::LoadDll()
{
	m_pTestDLL = NULL;

	m_hDllHandle = LoadLibrary("USBisoVM_DLL.dll");
	if (m_hDllHandle != NULL)
	{
		m_pTestDLL = (int (__stdcall *)(byte *))GetProcAddress(m_hDllHandle, "TestDLL");
		m_pFindUSBisoVMs = (int (__stdcall *)(byte *))GetProcAddress(m_hDllHandle, "FindUSBisoVMs");
		m_pGetManufacturerString = (int (__stdcall *)(int, byte *))GetProcAddress(m_hDllHandle, "GetManufacturerString");
		m_pGetProductString = (int (__stdcall *)(int, byte *))GetProcAddress(m_hDllHandle, "GetProductString");
		m_pGetVersionString = (int (__stdcall *)(int, byte *))GetProcAddress(m_hDllHandle, "GetVersionString");
		m_pReadUSBisoVM = (int (__stdcall *)(int, int, int, byte *))GetProcAddress(m_hDllHandle, "ReadUSBisoVM");
	}
}

void CCPP2010USBisoVMexampleDlg::FreeDll()
{
	FreeLibrary(m_hDllHandle);
}

int CCPP2010USBisoVMexampleDlg::Int16ParserWithHexSpecifier(CString str)
{
	int nLen = str.GetLength();
	short result = 0;
	
	if (nLen > 0)
	{
		const char* psz = (const char*)str;
		for(int i = 0; i < nLen; i++)
		{
			if (psz[i] >= '0' && psz[i] <= '9')
				result = result * 16 + (psz[i] - '0');
			else if (psz[i] >='a' && psz[i] <='f')
				result = result * 16 + (psz[i] - 'a' + 10);
			else if (psz[i] >='A' && psz[i] <='F')
				result = result * 16 + (psz[i] - 'A' + 10);
		}
	}

	return (int)result;
}

CString CCPP2010USBisoVMexampleDlg::EncodingGetString(byte *buffer, int nStart, int nLen)
{
	char sz[1024] = {0,};
	memcpy(sz, buffer + nStart, nLen);
	
	return CString(sz);
}

CString CCPP2010USBisoVMexampleDlg::EncodingGetString(byte *buffer)
{
	char sz[1025] = {0,};
	memcpy(sz, buffer, 1024);
	
	return CString(sz);
}

void CCPP2010USBisoVMexampleDlg::button1_Click()
{
	//Call test dll function
	if (m_pTestDLL != NULL)
	{
		byte buffer[1024] = {0,};
		int errnum = m_pTestDLL(buffer);
		textBox1.SetSel(-1, -1);
		textBox1.ReplaceSel(EncodingGetString(buffer) + "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button2_Click()
{
	//Find any connected USBIsoVm boards. This example will only display the first one found.
	if (m_pFindUSBisoVMs != NULL)
	{
		byte buffer[1024] = {0,};
		int errnum = m_pFindUSBisoVMs(buffer);
            
		if (errnum == 0)
		{
			textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR No USBISO boards found!\r\n");
			return;
		}

		isoVMfound = EncodingGetString(buffer, 0, 4);
		textBox1.SetSel(-1, -1);
		textBox1.ReplaceSel(isoVMfound + "\r\n");
           
		//enable buttons
		button2.EnableWindow(FALSE);
		button3.EnableWindow(TRUE);
		button4.EnableWindow(TRUE);
		button5.EnableWindow(TRUE);
		button6.EnableWindow(TRUE);
		button7.EnableWindow(TRUE);
		button8.EnableWindow(TRUE);
		button9.EnableWindow(TRUE);
		button10.EnableWindow(TRUE);
		button11.EnableWindow(TRUE);
	}
}


void CCPP2010USBisoVMexampleDlg::button3_Click()
{
	//call the GetManufacturerString function.
    //Returns the Manufacturer String unless there is an error.
	if (m_pGetManufacturerString != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
		//int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
		int errnum = m_pGetManufacturerString(ID, buffer);
            
        if (errnum == 0)
        {
			textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.SetSel(-1, -1);
		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button4_Click()
{
	//call the GetProductString function.
    //Returns the Product String unless there is an error.
	if (m_pGetProductString != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
        //int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pGetProductString(ID, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button5_Click()
{
	//call the GetVersionString function.
    //Returns the Version String unless there is an error.
	if (m_pGetVersionString != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
        //int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pGetVersionString(ID, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button6_Click()
{
	//call the ReadUSBisoVM function.
    //Returns the voltage of VM1 unless there is an error.
	if (m_pReadUSBisoVM != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
		//int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pReadUSBisoVM(ID, 1, 1, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button7_Click()
{
	//call the ReadUSBisoVM function.
    //Returns the voltage of VM2 unless there is an error.
	if (m_pReadUSBisoVM != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
		//int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pReadUSBisoVM(ID, 2, 1, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button8_Click()
{
	//call the ReadUSBisoVM function.
    //Returns the voltage of VM3 unless there is an error.
	if (m_pReadUSBisoVM != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
		//int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pReadUSBisoVM(ID, 3, 1, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button9_Click()
{
	//call the ReadUSBisoVM function.
    //Returns the voltage of VM4 unless there is an error.
	if (m_pReadUSBisoVM != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
		//int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pReadUSBisoVM(ID, 4, 1, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button10_Click()
{
	//call the ReadUSBisoVM function.
    //Returns the voltage of VM5 unless there is an error.
	if (m_pReadUSBisoVM != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
		//int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pReadUSBisoVM(ID, 5, 1, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::button11_Click()
{
	//call the ReadUSBisoVM function.
    //Returns the voltage of VM6 unless there is an error.
	if (m_pReadUSBisoVM != NULL)
	{
		byte buffer[1024] = {0,};
		int ID = Int16ParserWithHexSpecifier(isoVMfound);
		//int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
        int errnum = m_pReadUSBisoVM(ID, 6, 1, buffer);

        if (errnum == 0)
        {
            textBox1.SetSel(-1, -1);
			textBox1.ReplaceSel("ERROR Function Call Failed\r\n");
            return;
        }

		textBox1.ReplaceSel(EncodingGetString(buffer)+ "\r\n");
	}
}


void CCPP2010USBisoVMexampleDlg::OnClose()
{
	FreeDll();

	CDialogEx::OnClose();
}
